// GridDlg.cpp : implementation file
//

#include "stdafx.h"
#include "sdobjects_demo.h"
#include "GridDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGridDlg dialog


CGridDlg::CGridDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGridDlg::IDD, pParent)
	,_selector(&g_conn)
{
	//{{AFX_DATA_INIT(CGridDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	// we'll use the same SELECT statement we used in
	// the CFormDlg class
	_selector = "SELECT stor_id,ord_num,ord_date,qty,payterms,title_id from sales";
	_selector.execute();
}

void CGridDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGridDlg)
	DDX_Control(pDX, IDC_LIST1, _report_list);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGridDlg, CDialog)
	//{{AFX_MSG_MAP(CGridDlg)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST1, OnDoubleClickList1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGridDlg message handlers

BOOL CGridDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// make sure our selector is in a
	// valid state and a rowset exists
	if(!_selector.is_valid_state())
		; // intentional null statement
	else
	{
		// let's get an sdo_rowset object
		// from our selector object
		sdo_rowset rowset = _selector.rowset();

		// check this out! just use the >> operator to
		// load the data into the sdo_report_list_control
		// object. It will even set the properties on the
		// control to make sure they display properly
		// in report view. easy enough??!!
		rowset>>_report_list;
	}
	return TRUE;
}

void CGridDlg::OnDoubleClickList1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// here we'll respond to a double click event
	// to show how easy it is to get data from our
	// sdo_report_list object

	int clicked_row = _report_list.get_selected_row_index();

	// now lets get the sales.ord_num and the
	// sales.qty data for the selected row.
	// the columns are zero based relative to
	// the select statement, so we need columns 1 & 3.

	CString order_number, quantity;
	order_number = _report_list.get_text(clicked_row,1);
	quantity = _report_list.get_text(clicked_row,3);

	// here would could instantiate an sdo_updater if
	// we wanted to allow editing of the record, or
	// maybe bring up a related child list for the
	// record that was just double clicked.
	
	// ... do something

	CString message;
	message.Format("Order Number <%s>  Quantity <%s> "
				,order_number
				,quantity
				);

	AfxMessageBox(message); 
	
	*pResult = 0;
}
